package com.logicbig.example;

import org.junit.platform.suite.api.IncludePackages;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;

/**
 * Example demonstrating @IncludePackages annotation
 * This suite selects a broad package range but only includes specific packages
 */
@Suite
@SuiteDisplayName("Selective Package Inclusion Suite")
@SelectPackages("com.logicbig.example")  // Select everything under com.logicbig.example
@IncludePackages({
    "com.logicbig.example.auth",           // Include auth package
    "com.logicbig.example.payment",        // Include payment package
    // Note: order package is NOT included
    // Note: report package is NOT included
})
public class SuiteIncludePackagesExample {
    // Only tests from auth and payment packages will be executed
    // Tests from order and report packages will be excluded
}