package com.logicbig.example;

import org.junit.platform.suite.api.ExcludePackages;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.api.SuiteDisplayName;

/**
 * Example demonstrating @ExcludePackages annotation
 * This suite selects all packages but excludes specific ones
 */
@Suite
@SuiteDisplayName("Exclusion-Based Test Suite")
@SelectPackages("com.logicbig.example")  // Select everything under com.logicbig.example
@ExcludePackages({
    "com.logicbig.example.legacy",        // Exclude legacy package
    "com.logicbig.example.experimental",  // Exclude experimental package
    "com.logicbig.example.performance"    // Exclude performance package
})
public class SuiteExcludePackagesExample {
    // Tests from core and integration packages will be executed
    // Tests from legacy, experimental, and performance packages will be excluded
}