package com.logicbig.example;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

/**
 * Critical user test - INCLUDED
 * Matches: ends with "Test", tagged "critical" and "user"
 * Doesn't match: not "Legacy", not "slow", not "integration"
 */
@Tag("critical")
@Tag("user")
public class CriticalUserTest {
    
    @Test
    void testCriticalUserLogin() {
        System.out.println("CriticalUserTest - Critical user login test");
        assertTrue(true, "Critical user should be able to login");
    }
    
    @Test
    @Tag("security")
    void testUserSecurity() {
        System.out.println("CriticalUserTest - User security test");
        assertEquals("secure", "secure", "User security should be enforced");
    }
}