package com.logicbig.example;

import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;

import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;


public class TagFilteringLauncher {

    public static void main(String[] args) {

        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request()
                                                                          .selectors(
                        DiscoverySelectors.selectClass(MyIntegrationTest.class),
                        DiscoverySelectors.selectClass(MyCalcTest.class)
                )
                                                                          .filters(
                        TagFilter.includeTags("integration | calc-test"),
                        TagFilter.excludeTags("staging")
                )
                                                                          .build();

        Launcher launcher = LauncherFactory.create();

        // Create summary listener
        SummaryGeneratingListener listener = new SummaryGeneratingListener(){
           //to print what test passed
            @Override
            public void executionFinished(TestIdentifier testIdentifier,
                                          TestExecutionResult testExecutionResult) {
                if (testIdentifier.isTest()
                        && testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL) {

                    System.out.println("PASSED: " + testIdentifier.getDisplayName());
                }
            }
        };

        // Execute with listener
        launcher.execute(request, listener);

        // Print summary
        TestExecutionSummary summary = listener.getSummary();

        System.out.println("=================================");
        System.out.println("Test run finished");
        System.out.println("Tests found   : " + summary.getTestsFoundCount());

        System.out.println("Tests started : " + summary.getTestsStartedCount());
        System.out.println("Tests passed  : " + summary.getTestsSucceededCount());
        System.out.println("Tests failed  : " + summary.getTestsFailedCount());
        System.out.println("Tests skipped : " + summary.getTestsSkippedCount());
        System.out.println("=================================");

    }
}