package com.logicbig.example;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class ParameterizedMethodSourceTest {

    static Stream<String> palindromes() {
        return Stream.of("madam", "racecar", "level");
    }



    @ParameterizedTest
    @MethodSource("additionProvider")
    void testAddition(int a, int b, int expected) {
        assertEquals(expected, a + b);
    }

    @ParameterizedTest(name = "#{index} method source arg={0}")
    @MethodSource("palindromes")
    void isPalindromeFromMethodSource(String input) {
        assertTrue(new StringBuilder(input).reverse().toString().equals(input));
    }
    // Factory method must be static
    private static Stream<Arguments> additionProvider() {
        return Stream.of(
                Arguments.of(1, 2, 3),
                Arguments.of(0, 0, 0),
                Arguments.of(-5, 5, 0),
                Arguments.of(100, 200, 300)
        );
    }
}