package com.logicbig.example;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class ParameterizedCsvSourceTest {

    @ParameterizedTest(name = "#{index} length of '{0}' is {1}")
    @CsvSource({
            "car, 3",
            "level, 5",
            "radar, 5"
    })
    void lengthMatches(String input, int expectedLength) {
        assertEquals(expectedLength, input.length());
    }

    @ParameterizedTest(name = "#{index} '{0}' palindrome? {1}")
    @CsvSource({
            "madam, true",
            "hello, false",
            "racecar, true"
    })
    void palindromeCheck(String input, boolean expected) {
        assertEquals(expected, new StringBuilder(input).reverse().toString().equals(input));
    }

    @ParameterizedTest
    @CsvSource(delimiter = '|', value = {
            "apple|5|true",
            "banana|6|false",
            "cherry|6|true"
    })
    void testFruitDetails(String fruit, int length, boolean isTasty) {
        // Test logic here
        assertTrue(true);
    }
}