package com.logicbig.example;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.api.extension.ExtensionContext;

import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertTrue;

public class ParameterizedArgumentsProviderTest {

    static class PalindromeArgumentsProvider implements ArgumentsProvider {
        @Override
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of("madam", "racecar", "level").map(Arguments::of);
        }
    }

    @ParameterizedTest(name = "#{index} custom provider arg={0}")
    @ArgumentsSource(PalindromeArgumentsProvider.class)
    void usingCustomArgumentsProvider(String input) {
        assertTrue(new StringBuilder(input).reverse().toString().equals(input));
    }
}