package com.logicbig.example;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.Assumptions.abort;


class AssumptionsAbortExamples {

    @Test
    void abortWithoutMessage() {
        abort();
        // Any code below is not executed.
    }

    @Test
    void abortWithStringMessage() {
        abort("Skipping this test manually using Assumptions.abort(String)");
    }

    @Test
    void abortWithSupplierMessage() {
        abort(() -> "Skipped at " + System.currentTimeMillis());
    }

    @Test
    void abortConditionallyBasedOnEnv() {
        String token = System.getenv("EXAMPLE_TOKEN");
        if (token == null || token.isBlank()) {
            abort("Required environment variable EXAMPLE_TOKEN not set; skipping test");
        }
        // If the env var exists, additional test logic would go here.
    }

    @Test
    void testForWindowsOS() {
        String osName = System.getProperty("os.name").toLowerCase();

        if (!osName.contains("windows")) {
            // Abort if not running on Windows.
            abort("Aborting test: requires Windows Operating System");
        }

        // This code block runs exclusively on Windows machines.
        // In a real scenario, this would contain Windows-specific logic (e.g., file path checks).
        assertTrue(osName.contains("windows"), "This assertion should only run on Windows");
        assertFalse(osName.contains("mac"), "Should not be on Mac if we are here");
    }
}