package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.*;

import static org.junit.jupiter.api.Assertions.assertTrue;

class JreConditionExamplesTest {

    @Test
    @EnabledForJreRange(max = JRE.JAVA_17, disabledReason = "enable if max Java 17 and older")
    void runs_on_java17_and_older() {
        assertTrue(true);
    }

    @Test
    @EnabledForJreRange(min = JRE.JAVA_8, max = JRE.JAVA_17, disabledReason = "diable between Java 8 and Java 17")
    void disabled_on_java8_to_java17() {
        assertTrue(true);
    }

    @Test
    @EnabledOnJre(value = JRE.JAVA_17, disabledReason = "enable if Java 17")
    void runs_only_on_java17() {
        assertTrue(true);
    }

    @Test
    @DisabledOnJre(JRE.JAVA_8)
    void not_run_on_java8() {
        assertTrue(true);
    }

    @Test
    void always_runs_control() {
        assertTrue(true);
    }
}