package com.logicbig.example.display;

import org.junit.jupiter.api.DisplayNameGenerator;
import java.lang.reflect.Method;

public class CustomDisplayNameGenerator implements DisplayNameGenerator {

    @Override
    public String generateDisplayNameForClass(Class<?> testClass) {
        return prettify(testClass.getSimpleName());
    }

    @Override
    public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        return prettify(nestedClass.getSimpleName());
    }

    @Override
    public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        return prettify(testMethod.getName());
    }

    private static String prettify(String name) {
        // Replace underscores with spaces
        String s = name.replace('_', ' ');
        // Insert spaces before capitals in camelCase words
        s = s.replaceAll("(?<=[a-z])([A-Z])", " $1");
        // Trim and capitalize first letter
        s = s.trim();
        if (s.isEmpty())
            return s;
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}