package com.logicbig.example;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

public class BasicTagUsageTest {

    @Test
    @Tag("dev")
    void devTest() {
        assertEquals(2, 1 + 1);
        System.out.println("Running dev unit test");
    }

    @Test
    @Tag("integration")
    @Tag("end-to-end")
    void integrationTest() {
        assertTrue(true);
        System.out.println("Running integration unit test");
    }

    @Test
    void testWithoutMethodTag() {
        assertNotNull("test");
        System.out.println("Running test without tag");
    }
}