package com.logicbig.example;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.*;

public class StringAssertionsExample {

    @Test
    void myTest() {
        String value = "Hello, AssertJ World!";

        // prefix / suffix / contains
        assertThat(value).startsWith("Hello")
                         .endsWith("World!")
                         .contains("AssertJ")
                         .doesNotContain("JUnit");
        System.out.println("Prefix/suffix checks passed");

        // case-insensitive
        assertThat(value).isEqualToIgnoringCase("hello, assertj world!");
        System.out.println("Case-insensitive check passed");

        // length
        assertThat(value).hasSizeGreaterThan(5)
                         .hasSizeLessThan(100);
        System.out.println("Length checks passed");

        // regex
        assertThat(value).matches(".*AssertJ.*");
        System.out.println("Regex check passed");

        // blank / empty
        assertThat("").isEmpty();
        assertThat("  ").isBlank();
        System.out.println("Blank/empty checks passed");
    }
}