package com.logicbig.example;

import org.assertj.core.api.AutoCloseableSoftAssertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public class SoftAssertionsExample {

    record Product(String name,
                   double price,
                   boolean available) {}

    @Test
    void myTest() {
        Product product = new Product("Widget", 9.99, true);

        // try-with-resources style
        try (AutoCloseableSoftAssertions softly = new AutoCloseableSoftAssertions()) {
            softly.assertThat(product.name()).isNotBlank();
            softly.assertThat(product.price()).isLessThan(100);
        }
        System.out.println("Try-with-resources style passed");
        // lambda style - all assertions run even if some fail
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(product.name()).isEqualTo("Widget");
            softly.assertThat(product.price()).isGreaterThan(20);
            softly.assertThat(product.available()).isTrue();
            System.out.println("All soft asserts performed");
        });
        System.out.println("All soft assertions passed");
    }
}