package com.logicbig.example;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.*;

public class ExceptionAssertionsExample {

    static int divide(int a,
                      int b) {
        if (b == 0) throw new ArithmeticException("Division by zero");
        return a / b;
    }

    @Test
    void myTest() {
        // assertThatThrownBy style
        assertThatThrownBy(() -> divide(10, 0))
                .isInstanceOf(ArithmeticException.class)
                .hasMessage("Division by zero");
        System.out.println("assertThatThrownBy passed");

        // catchThrowable style
        Throwable thrown = catchThrowable(() -> Integer.parseInt("abc"));
        assertThat(thrown).isInstanceOf(NumberFormatException.class)
                          .hasMessageContaining("abc");
        System.out.println("catchThrowable passed");

        // assertThatExceptionOfType style
        assertThatExceptionOfType(ArithmeticException.class)
                .isThrownBy(() -> divide(5, 0))
                .withMessage("Division by zero");
        System.out.println("assertThatExceptionOfType passed");
    }
}