package com.logicbig.example;

import org.junit.jupiter.api.Test;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import static org.assertj.core.api.Assertions.*;

public class DateTimeAssertionsExample {

    @Test
    void myTest() {
        LocalDate date = LocalDate.of(2024, Month.JUNE, 15);

        // before / after
        assertThat(date).isBefore(LocalDate.of(2025, 1, 1))
                        .isAfter(LocalDate.of(2023, 1, 1));
        System.out.println("Before/after passed");

        // field checks
        assertThat(date).hasYear(2024)
                        .hasMonth(Month.JUNE)
                        .hasDayOfMonth(15);
        System.out.println("Field checks passed");

        LocalDateTime dt = LocalDateTime.of(2024, 6, 15, 10, 30);
        assertThat(dt).isAfter(LocalDateTime.of(2024, 1, 1, 0, 0))
                      .hasHour(10)
                      .hasMinute(30);
        System.out.println("LocalDateTime checks passed");
    }
}