package com.logicbig.example;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.*;

public class CustomErrorMessageExample {

    @Test
    void myTest() {
        String status = "ACTIVE";

        // withFailMessage before assertion
        assertThat(status).withFailMessage("User status must be ACTIVE")
                          .isEqualTo("ACTIVE");
        System.out.println("withFailMessage passed");

        // overridingErrorMessage (alias)
        assertThat(42).overridingErrorMessage("Score should be positive")
                      .isPositive();
        System.out.println("overridingErrorMessage passed");

        // lazy supplier - message built only on failure
        String user = "bob";
        assertThat(user).withFailMessage(() -> "User '" + user + "' is invalid")
                        .isNotBlank();
        System.out.println("Lazy message passed");
    }
}