package com.logicbig.example;

import org.assertj.core.api.AbstractAssert;

public class PersonAssert extends AbstractAssert<PersonAssert, Person> {

    public PersonAssert(Person actual) {
        super(actual, PersonAssert.class);
    }

    public static PersonAssert assertThat(Person actual) {
        return new PersonAssert(actual);
    }

    public PersonAssert isAdult() {
        isNotNull();
        if (actual.age() < 18) {
            failWithMessage("Expected adult but age was %d",
                            actual.age());
        }
        return this;
    }

    public PersonAssert hasName(String name) {
        isNotNull();
        if (!actual.name().equals(name)) {
            failWithMessage("Expected name <%s> but was <%s>",
                            name,
                            actual.name());
        }
        return this;
    }
}