package com.logicbig.example;

import org.junit.jupiter.api.Test;

public class CustomAssertionsExample {

    @Test
    void myTest() {
        Person alice = new Person("Alice", 30);
        Person bob = new Person("Bob", 15);

        // using custom assertion
        PersonAssert.assertThat(alice).isAdult().hasName("Alice");
        System.out.println("Alice custom assertion passed");

        PersonAssert.assertThat(bob).hasName("Bob");
        System.out.println("Bob name check passed");

        // chaining custom assertions
        PersonAssert.assertThat(alice).isAdult().hasName("Alice");
        System.out.println("Chained custom assertions passed");
    }
}