package com.logicbig.example;

import org.junit.jupiter.api.Test;

import org.assertj.core.api.Condition;
import java.util.List;
import static org.assertj.core.api.Assertions.*;

public class ConditionExample {

    @Test
    void myTest() {
        // define reusable conditions
        Condition<String> longWord = new Condition<>(s -> s.length() > 5,
                                                     "long word");
        Condition<String> startsWithA = new Condition<>(s -> s.startsWith("A"),
                                                        "starts with A");

        assertThat("Algorithm").is(longWord);
        System.out.println("longWord condition passed");

        assertThat("Algorithm").is(startsWithA);
        System.out.println("startsWithA condition passed");

        // allOf combinator
        assertThat("Algorithm").is(allOf(longWord, startsWithA));
        System.out.println("allOf passed");

        // anyOf combinator
        assertThat("JavaProgramming").is(anyOf(longWord, startsWithA));
        System.out.println("anyOf passed");

        // collection with condition
        List<String> words = List.of("Algorithm", "Array", "Abstract");
        assertThat(words).are(startsWithA);
        System.out.println("Collection condition passed");
    }
}