package com.logicbig.example;

import org.junit.jupiter.api.Test;
import java.util.List;
import static org.assertj.core.api.BDDAssertions.then;

public class BddAssertionsExample {

    static int add(int a,
                   int b) {return a + b;}

    @Test
    void myTest() {
        // Given-When-Then structure
        // given
        int a = 5, b = 3;

        // when
        int result = add(a, b);

        // then
        then(result).isEqualTo(8).isPositive();
        System.out.println("BDD integer check passed");

        // BDD with collections
        List<String> names = List.of("Alice", "Bob");
        then(names).hasSize(2).contains("Alice");
        System.out.println("BDD collection check passed");

        // BDD with string
        String greeting = "Hello, World";
        then(greeting).startsWith("Hello").endsWith("World");
        System.out.println("BDD string check passed");
    }
}