package com.logicbig.example;

import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Component;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class StreamProfileService {

    private final Environment env;

    public StreamProfileService(Environment env) {
        this.env = env;
    }

    public void processEnvironmentSpecificTasks() {
        List<String> requiredConfigs = Arrays.asList(
                "aws",
                "mongodb",
                "redis",
                "local-db",
                // demonstrate expression usage within stream
                "dev & !cloud"
        );

        List<String> activeConfigs =
                requiredConfigs.stream()
                               // Profiles.of returns the Profiles functional interface
                               // Environment.acceptsProfiles consumes it
                               .filter(expr -> env.acceptsProfiles(Profiles.of(expr)))
                               .collect(Collectors.toList());

        System.out.println("Active profiles (stream check): "
                                   + Arrays.toString(env.getActiveProfiles()));
        System.out.println("Active configurations for this environment: " +
                                   activeConfigs);
    }
}