package com.logicbig.example;

import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ProfilesStreamsMain {
    public static void main(String[] args) {
        // Simulate an environment with multiple active profiles
        AnnotationConfigApplicationContext ctx =
                new AnnotationConfigApplicationContext();
        ctx.getEnvironment().setActiveProfiles("dev", "redis");
        ctx.register(AppConfig.class);
        ctx.refresh();

        try {
            StreamProfileService svc =
                    ctx.getBean(StreamProfileService.class);
            svc.processEnvironmentSpecificTasks();
        } finally {
            ctx.close();
        }
    }
}