package com.logicbig.example;

import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ProdProfileDemo {
    public static void main(String[] args) {
        // Activate a non-default profile before registering the configuration
        AnnotationConfigApplicationContext context =
                new AnnotationConfigApplicationContext();
        context.getEnvironment().setActiveProfiles("prod");
        context.register(AppConfig.class);
        context.refresh();

        // With a non-default profile active:
        // - Bean with @Profile("default") is NOT loaded
        // - Bean without @Profile is still loaded

        if (context.containsBean("defaultProfileBean")) {
            System.out.println(context.getBean("defaultProfileBean"));
        }

        if (context.containsBean("noProfileBean")) {
            System.out.println(context.getBean("noProfileBean"));
        }

        if (context.containsBean("prodProfileBean")) {
            System.out.println(context.getBean("prodProfileBean"));
        }

        context.close();
    }
}