package com.logicbig.example;

import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class DefaultProfileDemo {
    public static void main(String[] args) {
        // No active profile explicitly set
        // → Spring activates the special "default" profile
        try (AnnotationConfigApplicationContext context =
                     new AnnotationConfigApplicationContext(AppConfig.class)) {

            if (context.containsBean("defaultProfileBean")) {
                System.out.println(context.getBean("defaultProfileBean"));
            }

            if (context.containsBean("noProfileBean")) {
                System.out.println(context.getBean("noProfileBean"));
            }

            if (context.containsBean("prodProfileBean")) {
                System.out.println(context.getBean("prodProfileBean"));
            }
        }
    }
}