package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.util.Assert;

@ContextConfiguration(
        inheritLocations = false,
        inheritInitializers = false,
        classes = {
                AppConfigExtended.class, OtherAppConfig.class
        })

public class ExtendedServiceTests extends BaseServiceTests {

    @Autowired
    private OrderService orderService;

    @Test
    public void testOrderCustomer() {
        String orders = orderService.getOrdersForCustomer("323");
        System.out.println("-- OrdersByCustomer test --");
        System.out.println(orders);
        Assert.notNull(orders, "Orders is null for id 323");
    }
}