package com.logicbig.example;

import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.NestedTestConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.springframework.test.context.NestedTestConfiguration.EnclosingConfiguration.INHERIT;
import static org.springframework.test.context.NestedTestConfiguration.EnclosingConfiguration.OVERRIDE;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = NestedConfigTest2.Config.class)
// This tells all @Nested classes to override this context
@NestedTestConfiguration(OVERRIDE)
public class NestedConfigTest2 {

    @Configuration
    static class Config {
        @Bean
        public String parentBean() {
            return "Parent Context";
        }
    }

    @Autowired
    private String parentBean;

    @Test
    void outerTest() {
        assertNotNull(parentBean);
        System.out.println("Outer: " + parentBean);
    }

    @Nested
    class InnerTest {
        @Configuration
        static class Config {
            @Bean
            public String parentBean() {
                return "Parent Context2";
            }
        }



        @Test
        void innerTest() {
            // This works because of @NestedTestConfiguration(INHERIT)
            assertNotNull(parentBean);
            System.out.println("Inner: " + parentBean);
        }
    }
}