package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@SpringJUnitConfig(AppConfig.class)
public class MockitoBeanTest {

    @MockitoBean
    UserRepository userRepository;

    @Autowired
    UserService userService;

    @Test
    public void testWithMockedRepository() {
        when(userRepository.findUserById("123")).thenReturn("Mocked user");

        String result = userService.getUser("123");
        System.out.println("Result: " + result);

        verify(userRepository).findUserById("123");

        assertEquals("Mocked user", result);
    }
}