package com.logicbig.example;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig
public class DynamicPropertySourceTest {

     @Autowired
     String appMode;

    @DynamicPropertySource
    static void registerProperties(DynamicPropertyRegistry registry) {
        registry.add("app.mode", () -> "runtimeValue");
    }

    @Test
    void myTest() {
        Assertions.assertEquals("runtimeValue", appMode);
    }

    @Configuration
    static class TestConfig {
        @Bean
        String appMode(Environment environment) {
            return environment.getProperty("app.mode");
        }
    }
}