package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextCustomizerFactories;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

import static org.junit.jupiter.api.Assertions.assertEquals;

@SpringJUnitConfig
@ContextCustomizerFactories(
        TestServiceContextCustomizerFactory.class)
class ContextCustomizerFactoriesTest {

    @Autowired
    private TestService testService;

    @Test
    void verifyContextCustomizerInjection() {
        assertEquals("customized", testService.value());
    }

    @Configuration
    static class TestConfig{}
}