package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;
import static org.junit.jupiter.api.Assertions.*;

@SpringJUnitConfig(AppConfig.class)
@EnableGreetingServiceMock
public class WithCustomizerTest {
    
    @Autowired
    private GreetingService greetingService;
    
    @Test
    public void testMockService() {
        String result = greetingService.getGreeting("John");
        System.out.println("Test 2 - Mock Service: " + result);
        assertTrue(result.contains("Mock Service"));
        assertTrue(result.contains("Hello"));
    }
}