package com.logicbig.example;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import java.util.Objects;

public class GreetingServiceContextCustomizer implements ContextCustomizer {
    
    private final String message;
    
    public GreetingServiceContextCustomizer(String message) {
        this.message = message;
    }
    
    @Override
    public void customizeContext(ConfigurableApplicationContext context,
                                MergedContextConfiguration mergedConfig) {
        
        // Remove existing GreetingService bean
        if (context.getBeanFactory().containsBean("greetingService")) {
            context.getBeanFactory()
                   .destroyBean("greetingService");
        }
        
        // Register mock bean
        MockGreetingService mockService = new MockGreetingService(message);
        context.getBeanFactory().registerSingleton("greetingService", mockService);
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        GreetingServiceContextCustomizer that = (GreetingServiceContextCustomizer) obj;
        return Objects.equals(message, that.message);
    }
    
    @Override
    public int hashCode() {
        return Objects.hashCode(message);
    }
}