package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;
import static org.junit.jupiter.api.Assertions.*;

@SpringJUnitConfig(AppConfig.class)
@EnableGreetingServiceMock(message = "Welcome")
public class CustomMessageTest {

    @Autowired
    private GreetingService greetingService;

    @Test
    public void testCustomMessage() {
        String result = greetingService.getGreeting("Jane");
        System.out.println("Test 3 - Custom Mock: " + result);
        assertTrue(result.contains("Mock Service"));
        assertTrue(result.contains("Welcome"));
    }
}