package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextCustomizerFactories;
import org.springframework.test.context.ContextCustomizerFactories.MergeMode;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(MyConfig.class)
@ContextCustomizerFactories(
        factories = CustomReplaceFactory.class,
        mergeMode = MergeMode.REPLACE_DEFAULTS
)
public class ReplaceDefaultsTest {

    // Default value is used because the dynamic property will be missing
    @Value("${dynamic.service.url:NOT_FOUND}")
    private String serviceUrl;

    /**
     * This method is normally picked up by DynamicPropertiesContextCustomizerFactory.
     * Since we used REPLACE_DEFAULTS, that factory is gone, and this method
     * will never be called.
     */
    @DynamicPropertySource
    static void registerProperties(DynamicPropertyRegistry registry) {
        registry.add("dynamic.service.url", () -> "http://dynamic-host:8080");
    }

    @Test
    void testMethod() {
        System.out.println(serviceUrl);
    }
}