package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

import static org.junit.jupiter.api.Assertions.*;

@SpringJUnitConfig(classes = TestAppConfig.class)
@ActiveProfiles("test")
public class UserServiceTest {

    @Autowired
    private UserService userService;

    // will be StubEmailService
    // when 'test' profile is active
    @Autowired
    private EmailService emailService;

    @Test
    public void testUserRegistration() {
        userService.registerUser("john@example.com");

        assertTrue(emailService instanceof StubEmailService,
                   "EmailService should be the stub when "
                           + "'test' profile is active");
        StubEmailService stub = (StubEmailService) emailService;
        assertEquals(1, stub.sentEmails.size());
        assertTrue(stub.sentEmails.get(0).contains("john@example.com"));
    }
}