package com.logicbig.example;

import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

@SpringJUnitConfig(classes = AppConfig.class)
@ActiveProfiles("base")
public class NestedProfileTest {

    @Autowired
    private Environment environment;

    @Test
    public void testOuterProfiles() {
        String[] profiles = environment.getActiveProfiles();
        System.out.println("Outer profiles: " + java.util.Arrays.toString(profiles));
        // Output: Outer profiles: [base]
        assertTrue(environment.acceptsProfiles(Profiles.of("base")));
        assertFalse(environment.acceptsProfiles(Profiles.of("dev")));
        assertFalse(environment.acceptsProfiles(Profiles.of("prod")));
    }

    @Nested
    @ActiveProfiles(value = "dev", inheritProfiles = true)
    class DevEnvironmentTests {

        @Autowired
        private Environment environment;

        @Test
        public void testDevProfiles() {
            String[] profiles = environment.getActiveProfiles();
            System.out.println("Dev profiles: " + java.util.Arrays.toString(profiles));
            // Output: Dev profiles: [base, dev]
            assertTrue(environment.acceptsProfiles(Profiles.of("base & dev")));
        }
    }

    @Nested
    @ActiveProfiles(value = "prod", inheritProfiles = false)
    class ProdEnvironmentTests {

        @Autowired
        private Environment environment;

        @Test
        public void testProdProfiles() {
            String[] profiles = environment.getActiveProfiles();
            System.out.println("Prod profiles: " + java.util.Arrays.toString(profiles));
            // Output: Prod profiles: [prod]
            assertFalse(environment.acceptsProfiles(Profiles.of("base")));
            assertTrue(environment.acceptsProfiles(Profiles.of("prod")));
        }
    }
}