package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import javax.sql.DataSource;
import java.util.Arrays;
import static org.junit.jupiter.api.Assertions.*;

@DevMySqlTest
public class OrderServiceTest {

    @Autowired
    private DataSource dataSource;

    @Autowired
    private Environment environment;

    @Test
    public void testOrder() {
        // has [dev, mysql] profiles
        String[] profiles = environment.getActiveProfiles();
        System.out.println("Active profiles (OrderServiceTest): " +
                                   Arrays.toString(profiles));

        assertNotNull(dataSource, "DataSource should be autowired "
                + "for dev/mysql profile combination");
        assertTrue(Arrays.asList(profiles).contains("dev"));
        assertTrue(Arrays.asList(profiles).contains("mysql"));
        assertFalse(Arrays.asList(profiles).contains("prod"));
        assertFalse(Arrays.asList(profiles).contains("postgres"));

        assertTrue(environment.acceptsProfiles(Profiles.of("dev & mysql")));
        assertFalse(environment.acceptsProfiles(
                Profiles.of("prod | postgres")));
    }
}