package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.springframework.core.env.Profiles;
import org.springframework.test.context.ActiveProfiles;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

@ActiveProfiles(value = "dev", inheritProfiles = true)
public class DevTest extends BaseTest {

    @Test
    public void test() {
        // Active profiles should include both base and dev
        String[] profiles = env.getActiveProfiles();
        assertTrue(contains(profiles, "base"),
                   "'base' should be active (inherited)");
        assertTrue(contains(profiles, "dev"),
                   "'dev' should be active (declared)");
        assertFalse(contains(profiles, "prod"),
                    "'prod' should not be active");

        // Environment-based checks (using Profiles.of)
        assertTrue(env.acceptsProfiles(Profiles.of("dev")));
        assertFalse(env.acceptsProfiles(Profiles.of("prod")));
        assertTrue(env.acceptsProfiles(Profiles.of("dev & base")));
    }
}