package com.logicbig.example;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.ollama.OllamaChatModel;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;

public class NamedClockTemplateExample {

    public static void main(String[] args) {

        // 1. Setup Ollama with Phi-3
        ChatModel model = OllamaChatModel.builder()
                                         .baseUrl("http://localhost:11434")
                                         .modelName("phi3:mini-128k")
                                         .numCtx(4096)
                                         .temperature(0.7)
                                         .build();

        // 2. Define a template that uses automatic date variables
        // The name "daily-task-assistant" helps you identify this template in logs
        String template = "Current Date: {{current_date}}. \n" +
                "Task: Write a short to-do list for a {{user_role}}.";

        String templateName = "daily-task-assistant";

        // 3. Use the specific method: from(template, name, clock)
        // We'll use a fixed clock here to demonstrate how to control 'current_date'
        Clock fixedClock = Clock.fixed(Instant.parse("2026-01-18T10:00:00Z"), ZoneId.of("UTC"));

        PromptTemplate promptTemplate =
                PromptTemplate.from(template, templateName, fixedClock);

        // 4. Apply the template
        // Notice we only provide 'user_role'. 'current_date' is handled by the Clock.
        Prompt prompt = promptTemplate.apply(Map.of("user_role",
                                                    "Software Engineer"));

        // 5. Execute with Phi-3
        String response = model.chat(prompt.text());

        System.out.println("-- Prompt (Named: " + templateName + ") --");
        System.out.println(prompt.text());
        System.out.println("\n-- Phi-3 Response --");
        System.out.println(response);
    }
}