package com.logicbig.example;

import dev.langchain4j.agent.tool.Tool;
import java.time.Instant;

public class SystemTools {

    @Tool("Returns the current system time in milliseconds")
    public long systemMillis() {
        return System.currentTimeMillis();
    }

    @Tool("Converts epoch milliseconds to a UTC timestamp")
    public String formatMillis(long millis) {
        return Instant.ofEpochMilli(millis).toString();
    }
}