package com.logicbig.example;

import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileChatMemoryStoreExample {

    public static void main(String[] args) throws Exception {

        ChatModel model = OllamaChatModel.builder()
                                         .baseUrl("http://localhost:11434")
                                         .modelName("phi3:mini-128k")
                                         .numCtx(4096)
                                         .temperature(0.7)
                                         .build();

        Path tempFile = Files.createTempFile("chat-memory-", ".txt");

        ChatMemoryStore store = new FileChatMemoryStore(tempFile);

        ChatMemory memory = MessageWindowChatMemory.builder()
                                                   .id("file-session")
                                                   .maxMessages(5)
                                                   .chatMemoryStore(store)
                                                   .build();

        memory.add(SystemMessage.from("You are a poet."));

        memory.add(UserMessage.from("Write a short poem on "
                                            + "Java programming language."));

        ChatResponse response = model.chat(memory.messages());
        memory.add(response.aiMessage());

        memory.add(UserMessage.from("Give a name to the poem."));

        ChatResponse response2 = model.chat(memory.messages());
        memory.add(response2.aiMessage());

        System.out.println("-- file json content --");
        Files.lines(tempFile).forEach(System.out::println);


    }

}