package com.logicbig.example;

import java.lang.reflect.Constructor;
import java.util.UUID;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;

public class StringConstructorTestInstanceFactory implements TestInstanceFactory {

    @Override
    public Object createTestInstance(
            TestInstanceFactoryContext factoryContext,
            ExtensionContext extensionContext) {

        Class<?> testClass = factoryContext.getTestClass();
        String id = "TEST-" + UUID.randomUUID();

        try {
            Constructor<?> constructor = testClass.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return constructor.newInstance(id);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(
                    "Test class must declare a constructor with a single String parameter: "
                            + testClass.getName(), e);
        } catch (Exception e) {
            throw new RuntimeException(
                    "Failed to create test instance for: " + testClass.getName(), e);
        }
    }
}