package com.logicbig.example;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import java.io.IOException;

public class IgnoreIOExceptionExtension implements TestExecutionExceptionHandler {

    @Override
    public void handleTestExecutionException(ExtensionContext context, 
                                               Throwable throwable) throws Throwable {
        if (throwable instanceof IOException) {
            System.err.println("Ignoring IOException in test: " + context.getDisplayName());
            return; 
        }
        throw throwable;
    }
}