package com.logicbig.example;

import org.junit.jupiter.api.*;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.Queue;

class QueueTest {

    // Shared state for the repetitions
    static Queue<String> queue = new ArrayDeque<>();

    @BeforeAll
    static void setup() {
        queue.add("Task 1");
        queue.add("Task 2");
        queue.add("Task 3");
    }

    @RepeatedTest(5)
    void testQueueDepletion(RepetitionInfo repetitionInfo) {
        if (repetitionInfo.getCurrentRepetition() <= 3) {
            // First 3 runs: Queue has items
            System.out.println("success test");
            Assertions.assertDoesNotThrow(() -> queue.remove(),
                "Should not fail on repetition " + repetitionInfo.getCurrentRepetition());
        } else {
            // 4th/5th run: Queue is empty, remove() throws NoSuchElementException
            System.out.println("failure test");
            Assertions.assertThrows(NoSuchElementException.class, () -> queue.remove(),
                "Should throw error on repetition " + repetitionInfo.getCurrentRepetition());
        }
    }
}