package com.logicbig.example;

import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;

class DiagnosticRepeatedTest {

    @RepeatedTest(value = 5, failureThreshold = 2)
    void resilientIntegrationTest(RepetitionInfo info) {
        try {
            // Your actual business logic/integration call
            runComplexIntegration();
            
        } catch (Exception e) {
            // APPLICATION LOGIC based on the threshold
            // If the threshold is > 1, we are in "investigation mode"
            if (info.getFailureThreshold() > 1) {
                performExpensiveDiagnostic(e);
            }
            
            throw e; // Still fail the test so JUnit can track the threshold
        }
    }

    private void runComplexIntegration() {
        //simulate failure
        fail("Network Glitch");
    }

    private void performExpensiveDiagnostic(Exception e) {
        System.err.println("Threshold is high: capturing full stack trace and system state...");
    }
}