package com.logicbig.example;

import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;
import org.opentest4j.TestAbortedException;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class ProgressiveRetryTest {

    @RepeatedTest(5)
    void flakyOperation(RepetitionInfo repetitionInfo) {
        System.out.println("Current repetition: " +
                                   repetitionInfo.getCurrentRepetition());
        int failuresSoFar = repetitionInfo.getFailureCount();

        if (failuresSoFar == 1) {
            //Simulate enabling debug logs
            System.out.println("Second attempt: enabled debug logging");
        }

        if (failuresSoFar == 2) {
            System.out.println("Aborting repetition");
            throw new TestAbortedException(
                    "Aborting remaining repetitions after " + failuresSoFar + " failures"
            );
        }

        // Simulate a flaky operation
        System.out.println("Performing flaky test");
        assertTrue(false);
    }
}