package com.logicbig.example;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import java.util.stream.Stream;

public class ParameterizedNamedTest {

    @ParameterizedTest
    @MethodSource("namedArguments")
    void testWithNamedInterface(String input) {
        System.out.println("Testing: " + input);
        Assertions.assertNotNull(input);
    }

    static Stream<Named<String>> namedArguments() {
        return Stream.of(
                Named.of("Upper case string", "ABC"),
                Named.of("Lower case string", "abc")
        );
    }
}