package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.*;

@ExtendWith(ParameterResolverTest.CustomResolver.class)
public class ParameterResolverTest {

    @Test
    void testInjection(String data) {
        System.out.println("received: " + data);
    }

    static class CustomResolver implements ParameterResolver {
        @Override
        public boolean supportsParameter(ParameterContext pc, ExtensionContext ec) {
            return pc.getParameter().getType() == String.class;
        }
        @Override
        public Object resolveParameter(ParameterContext pc, ExtensionContext ec) {
            return "hello world";
        }
    }
}