package com.logicbig.example;

import org.junit.jupiter.api.*;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import static org.junit.jupiter.api.Assertions.*;

@TestMethodOrder(MethodOrderer.Random.class)
class IndependentTestsExample {
    
    // These tests should pass regardless of execution order
    // because they don't share state
    
    @Test
    void calculateSum() {
        int result = 2 + 3;
        assertEquals(5, result);
        System.out.println("calculateSum executed");
    }
    
    @Test
    void checkStringLength() {
        String text = "Hello";
        assertEquals(5, text.length());
        System.out.println("checkStringLength executed");
    }
    
    @Test
    void verifyBoolean() {
        boolean flag = true;
        assertTrue(flag);
        System.out.println("verifyBoolean executed");
    }
    
    @Test
    void testArrayEquality() {
        int[] array1 = {1, 2, 3};
        int[] array2 = {1, 2, 3};
        assertArrayEquals(array1, array2);
        System.out.println("testArrayEquality executed");
    }
}