package com.logicbig.example;

import org.junit.jupiter.api.*;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import static org.junit.jupiter.api.Assertions.*;

@TestMethodOrder(MethodOrderer.OrderAnnotation.class)
public class MethodOrdererOrderAnnotationTest {
    
    private static StringBuilder executionLog = new StringBuilder();
    
    @Test
    @Order(3)
    void verifyResults() {
        executionLog.append("3-Verify ");
        System.out.println("Verify results executed (Order 3)");
        System.out.println("Current execution log: " + executionLog.toString());
        assertEquals("1-Setup 2-Execute 3-Verify ", executionLog.toString());
    }
    
    @Test
    @Order(1)
    void setupEnvironment() {
        executionLog.append("1-Setup ");
        System.out.println("Setup environment executed (Order 1 - first)");
        assertTrue(true);
    }
    
    @Test
    @Order(2)
    void executeProcess() {
        executionLog.append("2-Execute ");
        System.out.println("Execute process executed (Order 2)");
        assertTrue(true);
    }
    
    @Test
    @Order(4)
    void cleanupResources() {
        executionLog.append("4-Cleanup ");
        System.out.println("Cleanup resources executed (Order 4 - last)");
        System.out.println("Final execution log: " + executionLog.toString());
        assertEquals("1-Setup 2-Execute 3-Verify 4-Cleanup ", executionLog.toString());
    }
    
    @Test
    void testWithoutOrder() {
        // No @Order annotation - executes before ordered tests
        System.out.println("Test without @Order executed (before ordered tests)");
        assertTrue(true);
    }
}