package com.logicbig.example;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import java.io.IOException;

public class MyLifecycleExceptionHandler implements LifecycleMethodExecutionExceptionHandler {

    @Override
    public void handleBeforeEachMethodExecutionException(ExtensionContext context, 
                                                Throwable throwable) throws Throwable {
        if (throwable instanceof IOException) {
            System.err.println("⚠? Setup Warning: IO issue encountered, but proceeding with test: " 
                                + throwable.getMessage());
            return; // Swallow exception
        }
        throw throwable;
    }

    @Override
    public void handleAfterEachMethodExecutionException(ExtensionContext context, 
                                               Throwable throwable) throws Throwable {
        if (throwable instanceof UnsupportedOperationException) {
            System.err.println("⚠? Cleanup Note: Operation not supported on this platform.");
            return;
        }
        throw throwable;
    }
}